<?php

/**
* This file should always return an array containing
* the languages data. Please follow the structure 
* conventions in order to keep this file clean.
*/

return [

    [
        'name' => 'abkhaz',
        'native' => 'аҧсуа бызшәа, аҧсшәа',
        'iso-639-1' => 'ab',
        'iso-639-2t' => 'abk',
        'iso-639-2b' => 'abk',
        'iso-639-3' => 'abk',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'afar',
        'native' => 'afaraf',
        'iso-639-1' => 'aa',
        'iso-639-2t' => 'aar',
        'iso-639-2b' => 'aar',
        'iso-639-3' => 'aar',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'afrikaans',
        'native' => 'afrikaans',
        'iso-639-1' => 'af',
        'iso-639-2t' => 'afr',
        'iso-639-2b' => 'afr',
        'iso-639-3' => 'afr',
        'countries' => ['NA' => 'Namibia', 'ZA' => 'South Africa'],
        'scripts' => []
    ],
    [
        'name' => 'akan',
        'native' => 'akan',
        'iso-639-1' => 'ak',
        'iso-639-2t' => 'aka',
        'iso-639-2b' => 'aka',
        'iso-639-3' => 'aka + 2',
        'countries' => ['GH' => 'Ghana'],
        'scripts' => []
    ],
    [
        'name' => 'albanian',
        'native' => 'shqip',
        'iso-639-1' => 'sq',
        'iso-639-2t' => 'sqi',
        'iso-639-2b' => 'alb',
        'iso-639-3' => 'sqi + 4',
        'countries' => ['AL' => 'Albania'],
        'scripts' => []
    ],
    [
        'name' => 'amharic',
        'native' => 'አማርኛ',
        'iso-639-1' => 'am',
        'iso-639-2t' => 'amh',
        'iso-639-2b' => 'amh',
        'iso-639-3' => 'amh',
        'countries' => ['ET' => 'Ethiopia'],
        'scripts' => []
    ],
    [
        'name' => 'arabic',
        'native' => 'العربية',
        'iso-639-1' => 'ar',
        'iso-639-2t' => 'ara',
        'iso-639-2b' => 'ara',
        'iso-639-3' => 'ara + 30',
        'countries' => ['AE' => 'United Arab Emirates', 'BH' => 'Bahrain', 'DZ' => 'Algeria', 'EG' => 'Egypt', 'IQ' => 'Iraq', 'JO' => 'Jordan', 'KW' => 'Kuwait', 'LB' => 'Lebanon', 'LY' => 'Libya', 'MA' => 'Morocco', 'OM' => 'Oman', 'QA' => 'Qatar', 'SA' => 'Saudi Arabia', 'SD' => 'Sudan', 'SY' => 'Syria', 'TN' => 'Tunisia', 'YE' => 'Yemen'],
        'scripts' => []
    ],
    [
        'name' => 'aragonese',
        'native' => 'aragonés',
        'iso-639-1' => 'an',
        'iso-639-2t' => 'arg',
        'iso-639-2b' => 'arg',
        'iso-639-3' => 'arg',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'armenian',
        'native' => 'հայերեն',
        'iso-639-1' => 'hy',
        'iso-639-2t' => 'hye',
        'iso-639-2b' => 'arm',
        'iso-639-3' => 'hye',
        'countries' => ['AM' => 'Armenia'],
        'scripts' => []
    ],
    [
        'name' => 'assamese',
        'native' => 'অসমীয়া',
        'iso-639-1' => 'as',
        'iso-639-2t' => 'asm',
        'iso-639-2b' => 'asm',
        'iso-639-3' => 'asm',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'asu',
        'native' => 'kiathu',
        'iso-639-1' => '',                      // TODO
        'iso-639-2t' => '',                     // TODO
        'iso-639-2b' => '',                     // TODO
        'iso-639-3' => 'asa',
        'countries' => ['TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'avaric',
        'native' => 'авар мацӏ, магӏарул мацӏ',
        'iso-639-1' => 'av',
        'iso-639-2t' => 'ava',
        'iso-639-2b' => 'ava',
        'iso-639-3' => 'ava',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'avestan',
        'native' => 'avesta',
        'iso-639-1' => 'ae',
        'iso-639-2t' => 'ave',
        'iso-639-2b' => 'ave',
        'iso-639-3' => 'ave',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'aymara',
        'native' => 'aymar aru',
        'iso-639-1' => 'ay',
        'iso-639-2t' => 'aym',
        'iso-639-2b' => 'aym',
        'iso-639-3' => 'aym + 2',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'azerbaijani',
        'native' => 'azərbaycan dili',
        'iso-639-1' => 'az',
        'iso-639-2t' => 'aze',
        'iso-639-2b' => 'aze',
        'iso-639-3' => 'aze + 2',
        'countries' => ['AZ' => 'Azerbaijan'],
        'scripts' => ['cyrl' => 'cyrillic', 'latn' => 'latin']
    ],
    [
        'name' => 'bambara',
        'native' => 'bamanankan',
        'iso-639-1' => 'bm',
        'iso-639-2t' => 'bam',
        'iso-639-2b' => 'bam',
        'iso-639-3' => 'bam',
        'countries' => ['ML' => 'Mali'],
        'scripts' => []
    ],
    [
        'name' => 'bashkir',
        'native' => 'башҡорт теле',
        'iso-639-1' => 'ba',
        'iso-639-2t' => 'bak',
        'iso-639-2b' => 'bak',
        'iso-639-3' => 'bak',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'basque',
        'native' => 'euskara, euskera',
        'iso-639-1' => 'eu',
        'iso-639-2t' => 'eus',
        'iso-639-2b' => 'baq',
        'iso-639-3' => 'eus',
        'countries' => ['ES' => 'Spain'],
        'scripts' => []
    ],
    [
        'name' => 'belarusian',
        'native' => 'беларуская мова',
        'iso-639-1' => 'be',
        'iso-639-2t' => 'bel',
        'iso-639-2b' => 'bel',
        'iso-639-3' => 'bel',
        'countries' => ['BY' => 'Belarus'],
        'scripts' => []
    ],
    [
        'name' => 'bemba',
        'native' => 'chibemba',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'bem',
        'countries' => ['ZM' => 'Zambia'],
        'scripts' => []
    ],
    [
        'name' => 'bena',
        'native' => 'ekibena',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'bez',
        'countries' => ['TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'bengali',
        'native' => 'বাংলা',
        'iso-639-1' => 'bn',
        'iso-639-2t' => 'ben',
        'iso-639-2b' => 'ben',
        'iso-639-3' => 'ben',
        'countries' => ['BD' => 'Bangladesh', 'IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'bihari',
        'native' => 'भोजपुरी',
        'iso-639-1' => 'bh',
        'iso-639-2t' => 'bih',
        'iso-639-2b' => 'bih',
        'iso-639-3' => 'bih',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'bislama',
        'native' => 'bislama',
        'iso-639-1' => 'bi',
        'iso-639-2t' => 'bis',
        'iso-639-2b' => 'bis',
        'iso-639-3' => 'bis',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'bosnian',
        'native' => 'bosanski jezik',
        'iso-639-1' => 'bs',
        'iso-639-2t' => 'bos',
        'iso-639-2b' => 'bos',
        'iso-639-3' => 'bos',
        'countries' => ['BA' => 'Bosnia and Herzegovina'],
        'scripts' => []
    ],
    [
        'name' => 'breton',
        'native' => 'brezhoneg',
        'iso-639-1' => 'br',
        'iso-639-2t' => 'bre',
        'iso-639-2b' => 'bre',
        'iso-639-3' => 'bre',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'bulgarian',
        'native' => 'български език',
        'iso-639-1' => 'bg',
        'iso-639-2t' => 'bul',
        'iso-639-2b' => 'bul',
        'iso-639-3' => 'bul',
        'countries' => ['BG' => 'Bulgaria'],
        'scripts' => []
    ],
    [
        'name' => 'burmese',
        'native' => 'ဗမာစာ',
        'iso-639-1' => 'my',
        'iso-639-2t' => 'mya',
        'iso-639-2b' => 'bur',
        'iso-639-3' => 'mya',
        'countries' => ['MM' => 'Myanmar [Burma]'],
        'scripts' => []
    ],
    [
        'name' => 'catalan',
        'native' => 'català',
        'iso-639-1' => 'ca',
        'iso-639-2t' => 'cat',
        'iso-639-2b' => 'cat',
        'iso-639-3' => 'cat',
        'countries' => ['ES' => 'Spain'],
        'scripts' => []
    ],
    [
        'name' => 'central morocco tamazight',
        'native' => 'tachelhit',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'tzm',
        'countries' => ['MA' => 'Morocco'],
        'scripts' => ['latn' => 'latin']
    ],
    [
        'name' => 'chamorro',
        'native' => 'chamoru',
        'iso-639-1' => 'ch',
        'iso-639-2t' => 'cha',
        'iso-639-2b' => 'cha',
        'iso-639-3' => 'cha',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'chechen',
        'native' => 'нохчийн мотт',
        'iso-639-1' => 'ce',
        'iso-639-2t' => 'che',
        'iso-639-2b' => 'che',
        'iso-639-3' => 'che',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'cherokee',
        'native' => 'tsalagi',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'chr',
        'countries' => ['US' => 'United States'],
        'scripts' => []
    ],
    [
        'name' => 'chichewa, chewa, nyanja',
        'native' => 'chicheŵa, chinyanja',
        'iso-639-1' => 'ny',
        'iso-639-2t' => 'nya',
        'iso-639-2b' => 'nya',
        'iso-639-3' => 'nya',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'chiga',
        'native' => 'bachiga',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'cgg',
        'countries' => ['UG' => 'Uganda'],
        'scripts' => []
    ],
    [
        'name' => 'chinese',
        'native' => '中文 (zhōngwén), 汉语, 漢語',
        'iso-639-1' => 'zh',
        'iso-639-2t' => 'zho',
        'iso-639-2b' => 'chi',
        'iso-639-3' => 'zho + 13',
        'countries' => ['CN' => 'China', 'HK' => 'Hong Kong SAR China', 'MO' => 'Macau SAR China', 'SG' => 'Singapore', 'TW' => 'Taiwan'],
        'scripts' => ['hans' => 'simplified han', 'hant' => 'traditional han']
    ],
    [
        'name' => 'chuvash',
        'native' => 'чӑваш чӗлхи',
        'iso-639-1' => 'cv',
        'iso-639-2t' => 'chv',
        'iso-639-2b' => 'chv',
        'iso-639-3' => 'chv',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'cornish',
        'native' => 'kernewek',
        'iso-639-1' => 'kw',
        'iso-639-2t' => 'cor',
        'iso-639-2b' => 'cor',
        'iso-639-3' => 'cor',
        'countries' => ['GB' => 'United Kingdom'],
        'scripts' => []
    ],
    [
        'name' => 'corsican',
        'native' => 'corsu, lingua corsa',
        'iso-639-1' => 'co',
        'iso-639-2t' => 'cos',
        'iso-639-2b' => 'cos',
        'iso-639-3' => 'cos',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'cree',
        'native' => 'ᓀᐦᐃᔭᐍᐏᐣ',
        'iso-639-1' => 'cr',
        'iso-639-2t' => 'cre',
        'iso-639-2b' => 'cre',
        'iso-639-3' => 'cre + 6',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'croatian',
        'native' => 'hrvatski jezik',
        'iso-639-1' => 'hr',
        'iso-639-2t' => 'hrv',
        'iso-639-2b' => 'hrv',
        'iso-639-3' => 'hrv',
        'countries' => ['HR' => 'Croatia'],
        'scripts' => []
    ],
    [
        'name' => 'czech',
        'native' => 'čeština, český jazyk',
        'iso-639-1' => 'cs',
        'iso-639-2t' => 'ces',
        'iso-639-2b' => 'cze',
        'iso-639-3' => 'ces',
        'countries' => ['CZ' => 'Czech Republic'],
        'scripts' => []
    ],
    [
        'name' => 'danish',
        'native' => 'dansk',
        'iso-639-1' => 'da',
        'iso-639-2t' => 'dan',
        'iso-639-2b' => 'dan',
        'iso-639-3' => 'dan',
        'countries' => ['DK' => 'Denmark'],
        'scripts' => []
    ],
    [
        'name' => 'divehi, dhivehi, maldivian',
        'native' => 'ދިވެހި',
        'iso-639-1' => 'dv',
        'iso-639-2t' => 'div',
        'iso-639-2b' => 'div',
        'iso-639-3' => 'div',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'dutch',
        'native' => 'nederlands',
        'iso-639-1' => 'nl',
        'iso-639-2t' => 'nld',
        'iso-639-2b' => 'dut',
        'iso-639-3' => 'nld',
        'countries' => ['BE' => 'Belgium', 'NL' => 'Netherlands'],
        'scripts' => []
    ],
    [
        'name' => 'dzongkha',
        'native' => 'རྫོང་ཁ',
        'iso-639-1' => 'dz',
        'iso-639-2t' => 'dzo',
        'iso-639-2b' => 'dzo',
        'iso-639-3' => 'dzo',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'embu',
        'native' => 'kiembu',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'ebu',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'english',
        'native' => 'english',
        'iso-639-1' => 'en',
        'iso-639-2t' => 'eng',
        'iso-639-2b' => 'eng',
        'iso-639-3' => 'eng',
        'countries' => ['AS' => 'American Samoa', 'AU' => 'Australia', 'BE' => 'Belgium', 'BW' => 'Botswana', 'BZ' => 'Belize', 'CA' => 'Canada', 'GB' => 'United Kingdom', 'GU' => 'Guam', 'HK' => 'Hong Kong SAR China', 'IE' => 'Ireland', 'IN' => 'India', 'JM' => 'Jamaica', 'MH' => 'Marshall Islands', 'MP' => 'Northern Mariana Islands', 'MT' => 'Malta', 'MU' => 'Mauritius', 'NA' => 'Namibia', 'NZ' => 'New Zealand', 'PH' => 'Philippines', 'PK' => 'Pakistan', 'SG' => 'Singapore', 'TT' => 'Trinidad and Tobago', 'UM' => 'U.S. Minor Outlying Islands', 'US' => 'United States', 'VI' => 'U.S. Virgin Islands', 'ZA' => 'South Africa', 'ZW' => 'Zimbabwe'],
        'scripts' => []
    ],
    [
        'name' => 'esperanto',
        'native' => 'esperanto',
        'iso-639-1' => 'eo',
        'iso-639-2t' => 'epo',
        'iso-639-2b' => 'epo',
        'iso-639-3' => 'epo',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'estonian',
        'native' => 'eesti, eesti keel',
        'iso-639-1' => 'et',
        'iso-639-2t' => 'est',
        'iso-639-2b' => 'est',
        'iso-639-3' => 'est + 2',
        'countries' => ['EE' => 'Estonia'],
        'scripts' => []
    ],
    [
        'name' => 'ewe',
        'native' => 'eʋegbe',
        'iso-639-1' => 'ee',
        'iso-639-2t' => 'ewe',
        'iso-639-2b' => 'ewe',
        'iso-639-3' => 'ewe',
        'countries' => ['GH' => 'Ghana', 'TG' => 'Togo'],
        'scripts' => []
    ],
    [
        'name' => 'faroese',
        'native' => 'føroyskt',
        'iso-639-1' => 'fo',
        'iso-639-2t' => 'fao',
        'iso-639-2b' => 'fao',
        'iso-639-3' => 'fao',
        'countries' => ['FO' => 'Faroe Islands'],
        'scripts' => []
    ],
    [
        'name' => 'fijian',
        'native' => 'vosa vakaviti',
        'iso-639-1' => 'fj',
        'iso-639-2t' => 'fij',
        'iso-639-2b' => 'fij',
        'iso-639-3' => 'fij',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'filipino',
        'native' => 'filipino',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => 'fil',
        'iso-639-2b' => 'fil',
        'iso-639-3' => 'fil',
        'countries' => ['PH' => 'Philippines'],
        'scripts' => []
    ],
    [
        'name' => 'finnish',
        'native' => 'suomi, suomen kieli',
        'iso-639-1' => 'fi',
        'iso-639-2t' => 'fin',
        'iso-639-2b' => 'fin',
        'iso-639-3' => 'fin',
        'countries' => ['FI' => 'Finland'],
        'scripts' => []
    ],
    [
        'name' => 'french',
        'native' => 'français',
        'iso-639-1' => 'fr',
        'iso-639-2t' => 'fra',
        'iso-639-2b' => 'fre',
        'iso-639-3' => 'fra',
        'countries' => ['BE' => 'Belgium', 'BF' => 'Burkina Faso', 'BI' => 'Burundi', 'BJ' => 'Benin', 'BL' => 'Saint Barthélemy', 'CA' => 'Canada', 'CD' => 'Congo - Kinshasa', 'CF' => 'Central African Republic', 'CG' => 'Congo - Brazzaville', 'CH' => 'Switzerland', 'CI' => 'Côte d’Ivoire', 'CM' => 'Cameroon', 'DJ' => 'Djibouti', 'FR' => 'France', 'GA' => 'Gabon', 'GN' => 'Guinea', 'GP' => 'Guadeloupe', 'GQ' => 'Equatorial Guinea', 'KM' => 'Comoros', 'LU' => 'Luxembourg', 'MC' => 'Monaco', 'MF' => 'Saint Martin', 'MG' => 'Madagascar', 'ML' => 'Mali', 'MQ' => 'Martinique', 'NE' => 'Niger', 'RE' => 'Réunion', 'RW' => 'Rwanda', 'SN' => 'Senegal', 'TD' => 'Chad', 'TG' => 'Togo'],
        'scripts' => []
    ],
    [
        'name' => 'fulah',
        'native' => 'fulfulde, pulaar, pular',
        'iso-639-1' => 'ff',
        'iso-639-2t' => 'ful',
        'iso-639-2b' => 'ful',
        'iso-639-3' => 'ful + 9',
        'countries' => ['SN' => 'Senegal'],
        'scripts' => []
    ],
    [
        'name' => 'galician',
        'native' => 'galego',
        'iso-639-1' => 'gl',
        'iso-639-2t' => 'glg',
        'iso-639-2b' => 'glg',
        'iso-639-3' => 'glg',
        'countries' => ['ES' => 'Spain'],
        'scripts' => []
    ],
    [
        'name' => 'georgian',
        'native' => 'ქართული',
        'iso-639-1' => 'ka',
        'iso-639-2t' => 'kat',
        'iso-639-2b' => 'geo',
        'iso-639-3' => 'kat',
        'countries' => ['GE' => 'Georgia'],
        'scripts' => []
    ],
    [
        'name' => 'german',
        'native' => 'deutsch',
        'iso-639-1' => 'de',
        'iso-639-2t' => 'deu',
        'iso-639-2b' => 'ger',
        'iso-639-3' => 'deu',
        'countries' => ['AT' => 'Austria', 'BE' => 'Belgium', 'CH' => 'Switzerland', 'DE' => 'Germany', 'LI' => 'Liechtenstein', 'LU' => 'Luxembourg'],
        'scripts' => []
    ],
    [
        'name' => 'greek',
        'native' => 'ελληνικά',
        'iso-639-1' => 'el',
        'iso-639-2t' => 'ell',
        'iso-639-2b' => 'gre',
        'iso-639-3' => 'ell',
        'countries' => ['CY' => 'Cyprus', 'GR' => 'Greece'],
        'scripts' => []
    ],
    [
        'name' => 'guaraní',
        'native' => 'avañe\'ẽ',
        'iso-639-1' => 'gn',
        'iso-639-2t' => 'grn',
        'iso-639-2b' => 'grn',
        'iso-639-3' => 'grn + 5',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'gujarati',
        'native' => 'ગુજરાતી',
        'iso-639-1' => 'gu',
        'iso-639-2t' => 'guj',
        'iso-639-2b' => 'guj',
        'iso-639-3' => 'guj',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'gusii',
        'native' => 'ekegusii',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'guz',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'haitian, haitian creole',
        'native' => 'kreyòl ayisyen',
        'iso-639-1' => 'ht',
        'iso-639-2t' => 'hat',
        'iso-639-2b' => 'hat',
        'iso-639-3' => 'hat',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'hausa',
        'native' => '(hausa) هَوُسَ',
        'iso-639-1' => 'ha',
        'iso-639-2t' => 'hau',
        'iso-639-2b' => 'hau',
        'iso-639-3' => 'hau',
        'countries' => ['GH' => 'Ghana', 'NE' => 'Niger', 'NG' => 'Nigeria'],
        'scripts' => ['latn' => 'latin']
    ],
    [
        'name' => 'hawaiian',
        'native' => '’olelo hawai’i',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => 'haw',
        'iso-639-2b' => 'haw',
        'iso-639-3' => 'haw',
        'countries' => ['US' => 'United States'],
        'scripts' => []
    ],
    [
        'name' => 'hebrew',
        'native' => 'עברית',
        'iso-639-1' => 'he',
        'iso-639-2t' => 'heb',
        'iso-639-2b' => 'heb',
        'iso-639-3' => 'heb',
        'countries' => ['IL' => 'Israel'],
        'deprecated' => [
            'iso-639-1' => 'iw'
        ],
        'scripts' => []
    ],
    [
        'name' => 'herero',
        'native' => 'otjiherero',
        'iso-639-1' => 'hz',
        'iso-639-2t' => 'her',
        'iso-639-2b' => 'her',
        'iso-639-3' => 'her',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'hindi',
        'native' => 'हिन्दी, हिंदी',
        'iso-639-1' => 'hi',
        'iso-639-2t' => 'hin',
        'iso-639-2b' => 'hin',
        'iso-639-3' => 'hin',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'hiri motu',
        'native' => 'hiri motu',
        'iso-639-1' => 'ho',
        'iso-639-2t' => 'hmo',
        'iso-639-2b' => 'hmo',
        'iso-639-3' => 'hmo',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'hungarian',
        'native' => 'magyar',
        'iso-639-1' => 'hu',
        'iso-639-2t' => 'hun',
        'iso-639-2b' => 'hun',
        'iso-639-3' => 'hun',
        'countries' => ['HU' => 'Hungary'],
        'scripts' => []
    ],
    [
        'name' => 'interlingua',
        'native' => 'interlingua',
        'iso-639-1' => 'ia',
        'iso-639-2t' => 'ina',
        'iso-639-2b' => 'ina',
        'iso-639-3' => 'ina',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'indonesian',
        'native' => 'bahasa indonesia',
        'iso-639-1' => 'id',
        'iso-639-2t' => 'ind',
        'iso-639-2b' => 'ind',
        'iso-639-3' => 'ind',
        'countries' => ['ID' => 'Indonesia'],
        'scripts' => []
    ],
    [
        'name' => 'interlingue',
        'native' => 'originally called occidental; then interlingue after WWII',
        'iso-639-1' => 'ie',
        'iso-639-2t' => 'ile',
        'iso-639-2b' => 'ile',
        'iso-639-3' => 'ile',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'irish',
        'native' => 'gaeilge',
        'iso-639-1' => 'ga',
        'iso-639-2t' => 'gle',
        'iso-639-2b' => 'gle',
        'iso-639-3' => 'gle',
        'countries' => ['IE' => 'Ireland'],
        'scripts' => []
    ],
    [
        'name' => 'igbo',
        'native' => 'asụsụ igbo',
        'iso-639-1' => 'ig',
        'iso-639-2t' => 'ibo',
        'iso-639-2b' => 'ibo',
        'iso-639-3' => 'ibo',
        'countries' => ['NG' => 'Nigeria'],
        'scripts' => []
    ],
    [
        'name' => 'inupiaq',
        'native' => 'iñupiaq, iñupiatun',
        'iso-639-1' => 'ik',
        'iso-639-2t' => 'ipk',
        'iso-639-2b' => 'ipk',
        'iso-639-3' => 'ipk + 2',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'ido',
        'native' => 'ido',
        'iso-639-1' => 'io',
        'iso-639-2t' => 'ido',
        'iso-639-2b' => 'ido',
        'iso-639-3' => 'ido',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'icelandic',
        'native' => 'íslenska',
        'iso-639-1' => 'is',
        'iso-639-2t' => 'isl',
        'iso-639-2b' => 'ice',
        'iso-639-3' => 'isl',
        'countries' => ['IS' => 'Iceland'],
        'scripts' => []
    ],
    [
        'name' => 'italian',
        'native' => 'italiano',
        'iso-639-1' => 'it',
        'iso-639-2t' => 'ita',
        'iso-639-2b' => 'ita',
        'iso-639-3' => 'ita',
        'countries' => ['CH' => 'Switzerland', 'IT' => 'Italy'],
        'scripts' => []
    ],
    [
        'name' => 'inuktitut',
        'native' => 'ᐃᓄᒃᑎᑐᑦ',
        'iso-639-1' => 'iu',
        'iso-639-2t' => 'iku',
        'iso-639-2b' => 'iku',
        'iso-639-3' => 'iku + 2',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'japanese',
        'native' => '日本語 (にほんご)',
        'iso-639-1' => 'ja',
        'iso-639-2t' => 'jpn',
        'iso-639-2b' => 'jpn',
        'iso-639-3' => 'jpn',
        'countries' => ['JP' => 'Japan'],
        'scripts' => []
    ],
    [
        'name' => 'javanese',
        'native' => 'basa jawa',
        'iso-639-1' => 'jv',
        'iso-639-2t' => 'jav',
        'iso-639-2b' => 'jav',
        'iso-639-3' => 'jav',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'kabuverdianu',
        'native' => 'crioulo',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'kea',
        'countries' => ['CV' => 'Cape Verde'],
        'scripts' => []
    ],
    [
        'name' => 'kabyle',
        'native' => 'taqbaylit',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'kab',
        'countries' => ['DZ' => 'Algeria'],
        'scripts' => []
    ],
    [
        'name' => 'kalenjin',
        'native' => 'kalenjin',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'kln + 9',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'kalaallisut',
        'native' => 'kalaallisut, kalaallit oqaasii',
        'iso-639-1' => 'kl',
        'iso-639-2t' => 'kal',
        'iso-639-2b' => 'kal',
        'iso-639-3' => 'kal',
        'countries' => ['GL' => 'Greenland'],
        'scripts' => []
    ],
    [
        'name' => 'kamba',
        'native' => 'kamba',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'kam',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'kannada',
        'native' => 'ಕನ್ನಡ',
        'iso-639-1' => 'kn',
        'iso-639-2t' => 'kan',
        'iso-639-2b' => 'kan',
        'iso-639-3' => 'kan',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'kanuri',
        'native' => 'kanuri',
        'iso-639-1' => 'kr',
        'iso-639-2t' => 'kau',
        'iso-639-2b' => 'kau',
        'iso-639-3' => 'kau + 3',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'kashmiri',
        'native' => 'कश्मीरी, كشميري‎',
        'iso-639-1' => 'ks',
        'iso-639-2t' => 'kas',
        'iso-639-2b' => 'kas',
        'iso-639-3' => 'kas',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'kazakh',
        'native' => 'қазақ тілі',
        'iso-639-1' => 'kk',
        'iso-639-2t' => 'kaz',
        'iso-639-2b' => 'kaz',
        'iso-639-3' => 'kaz',
        'countries' => ['KZ' => 'Kazakhstan'],
        'scripts' => ['cyrl' => 'cyrillic']
    ],
    [
        'name' => 'khmer',
        'native' => 'ខ្មែរ, ខេមរភាសា, ភាសាខ្មែរ',
        'iso-639-1' => 'km',
        'iso-639-2t' => 'khm',
        'iso-639-2b' => 'khm',
        'iso-639-3' => 'khm',
        'countries' => ['KH' => 'Cambodia'],
        'scripts' => []
    ],
    [
        'name' => 'kikuyu',
        'native' => 'gĩkũyũ',
        'iso-639-1' => 'ki',
        'iso-639-2t' => 'kik',
        'iso-639-2b' => 'kik',
        'iso-639-3' => 'kik',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'kinyarwanda',
        'native' => 'ikinyarwanda',
        'iso-639-1' => 'rw',
        'iso-639-2t' => 'kin',
        'iso-639-2b' => 'kin',
        'iso-639-3' => 'kin',
        'countries' => ['RW' => 'Rwanda'],
        'scripts' => []
    ],
    [
        'name' => 'kyrgyz',
        'native' => 'кыргызча, кыргыз тили',
        'iso-639-1' => 'ky',
        'iso-639-2t' => 'kir',
        'iso-639-2b' => 'kir',
        'iso-639-3' => 'kir',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'komi',
        'native' => 'коми кыв',
        'iso-639-1' => 'kv',
        'iso-639-2t' => 'kom',
        'iso-639-2b' => 'kom',
        'iso-639-3' => 'kom + 2',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'kongo',
        'native' => 'kikongo',
        'iso-639-1' => 'kg',
        'iso-639-2t' => 'kon',
        'iso-639-2b' => 'kon',
        'iso-639-3' => 'kon + 3',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'konkani',
        'native' => 'konkani',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'kok + 2',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'korean',
        'native' => '한국어, 조선어',
        'iso-639-1' => 'ko',
        'iso-639-2t' => 'kor',
        'iso-639-2b' => 'kor',
        'iso-639-3' => 'kor',
        'countries' => ['KR' => 'South Korea'],
        'scripts' => []
    ],
    [
        'name' => 'koyra chiini',
        'native' => 'songai',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'khq',
        'countries' => ['ML' => 'Mali'],
        'scripts' => []
    ],
    [
        'name' => 'koyraboro senni',
        'native' => 'koyraboro senni',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'ses',
        'countries' => ['ML' => 'Mali'],
        'scripts' => []
    ],
    [
        'name' => 'kurdish',
        'native' => 'kurdî, كوردی‎',
        'iso-639-1' => 'ku',
        'iso-639-2t' => 'kur',
        'iso-639-2b' => 'kur',
        'iso-639-3' => 'kur + 3',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'kwanyama, kuanyama',
        'native' => 'kuanyama',
        'iso-639-1' => 'kj',
        'iso-639-2t' => 'kua',
        'iso-639-2b' => 'kua',
        'iso-639-3' => 'kua',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'latin',
        'native' => 'latine, lingua latina',
        'iso-639-1' => 'la',
        'iso-639-2t' => 'lat',
        'iso-639-2b' => 'lat',
        'iso-639-3' => 'lat',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'luxembourgish, letzeburgesch',
        'native' => 'lëtzebuergesch',
        'iso-639-1' => 'lb',
        'iso-639-2t' => 'ltz',
        'iso-639-2b' => 'ltz',
        'iso-639-3' => 'ltz',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'ganda',
        'native' => 'luganda',
        'iso-639-1' => 'lg',
        'iso-639-2t' => 'lug',
        'iso-639-2b' => 'lug',
        'iso-639-3' => 'lug',
        'countries' => ['UG' => 'Uganda'],
        'scripts' => []
    ],
    [
        'name' => 'limburgish, limburgan, limburger',
        'native' => 'limburgs',
        'iso-639-1' => 'li',
        'iso-639-2t' => 'lim',
        'iso-639-2b' => 'lim',
        'iso-639-3' => 'lim',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'lingala',
        'native' => 'lingála',
        'iso-639-1' => 'ln',
        'iso-639-2t' => 'lin',
        'iso-639-2b' => 'lin',
        'iso-639-3' => 'lin',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'lao',
        'native' => 'ພາສາລາວ',
        'iso-639-1' => 'lo',
        'iso-639-2t' => 'lao',
        'iso-639-2b' => 'lao',
        'iso-639-3' => 'lao',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'langi',
        'native' => 'kilaangi',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'lag',
        'countries' => ['TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'lithuanian',
        'native' => 'lietuvių kalba',
        'iso-639-1' => 'lt',
        'iso-639-2t' => 'lit',
        'iso-639-2b' => 'lit',
        'iso-639-3' => 'lit',
        'countries' => ['LT' => 'Lithuania'],
        'scripts' => []
    ],
    [
        'name' => 'luba-katanga',
        'native' => 'tshiluba',
        'iso-639-1' => 'lu',
        'iso-639-2t' => 'lub',
        'iso-639-2b' => 'lub',
        'iso-639-3' => 'lub',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'luo',
        'native' => 'luo',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'luo',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'luyia',
        'native' => 'luyia',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'luy + 14',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'latvian',
        'native' => 'latviešu valoda',
        'iso-639-1' => 'lv',
        'iso-639-2t' => 'lav',
        'iso-639-2b' => 'lav',
        'iso-639-3' => 'lav + 2',
        'countries' => ['LV' => 'Latvia'],
        'scripts' => []
    ],
    [
        'name' => 'manx',
        'native' => 'gaelg, gailck',
        'iso-639-1' => 'gv',
        'iso-639-2t' => 'glv',
        'iso-639-2b' => 'glv',
        'iso-639-3' => 'glv',
        'countries' => ['GB' => 'United Kingdom'],
        'scripts' => []
    ],
    [
        'name' => 'macedonian',
        'native' => 'македонски јазик',
        'iso-639-1' => 'mk',
        'iso-639-2t' => 'mkd',
        'iso-639-2b' => 'mac',
        'iso-639-3' => 'mkd',
        'countries' => ['MK' => 'Macedonia'],
        'scripts' => []
    ],
    [
        'name' => 'machame',
        'native' => 'machame',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'jmc',
        'countries' => ['TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'makonde',
        'native' => 'makonde',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'kde',
        'countries' => ['TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'malagasy',
        'native' => 'fiteny malagasy',
        'iso-639-1' => 'mg',
        'iso-639-2t' => 'mlg',
        'iso-639-2b' => 'mlg',
        'iso-639-3' => 'mlg + 10',
        'countries' => ['MG' => 'Madagascar'],
        'scripts' => []
    ],
    [
        'name' => 'malay',
        'native' => 'bahasa melayu, بهاس ملايو‎',
        'iso-639-1' => 'ms',
        'iso-639-2t' => 'msa',
        'iso-639-2b' => 'may',
        'iso-639-3' => 'msa + 13',
        'countries' => ['BN' => 'Brunei', 'MY' => 'Malaysia'],
        'scripts' => []
    ],
    [
        'name' => 'malayalam',
        'native' => 'മലയാളം',
        'iso-639-1' => 'ml',
        'iso-639-2t' => 'mal',
        'iso-639-2b' => 'mal',
        'iso-639-3' => 'mal',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'maltese',
        'native' => 'malti',
        'iso-639-1' => 'mt',
        'iso-639-2t' => 'mlt',
        'iso-639-2b' => 'mlt',
        'iso-639-3' => 'mlt',
        'countries' => ['MT' => 'Malta'],
        'scripts' => []
    ],
    [
        'name' => 'māori',
        'native' => 'te reo māori',
        'iso-639-1' => 'mi',
        'iso-639-2t' => 'mri',
        'iso-639-2b' => 'mao',
        'iso-639-3' => 'mri',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'marathi',
        'native' => 'मराठी',
        'iso-639-1' => 'mr',
        'iso-639-2t' => 'mar',
        'iso-639-2b' => 'mar',
        'iso-639-3' => 'mar',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'marshallese',
        'native' => 'kajin m̧ajeļ',
        'iso-639-1' => 'mh',
        'iso-639-2t' => 'mah',
        'iso-639-2b' => 'mah',
        'iso-639-3' => 'mah',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'masai',
        'native' => 'masai',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'mas',
        'countries' => ['KE' => 'Kenya', 'TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'meru',
        'native' => 'meru',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'mer',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'mongolian',
        'native' => 'монгол',
        'iso-639-1' => 'mn',
        'iso-639-2t' => 'mon',
        'iso-639-2b' => 'mon',
        'iso-639-3' => 'mon + 2',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'morisyen',
        'native' => 'morisyen',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'mfe',
        'countries' => ['MU' => 'Mauritius'],
        'scripts' => []
    ],
    [
        'name' => 'nama',
        'native' => 'khoekhoe',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'naq',
        'countries' => ['NA' => 'Namibia'],
        'scripts' => []
    ],
    [
        'name' => 'nauru',
        'native' => 'ekakairũ naoero',
        'iso-639-1' => 'na',
        'iso-639-2t' => 'nau',
        'iso-639-2b' => 'nau',
        'iso-639-3' => 'nau',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'navajo, navaho',
        'native' => 'diné bizaad, dinékʼehǰí',
        'iso-639-1' => 'nv',
        'iso-639-2t' => 'nav',
        'iso-639-2b' => 'nav',
        'iso-639-3' => 'nav',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'northern ndebele',
        'native' => 'isindebele',
        'iso-639-1' => 'nd',
        'iso-639-2t' => 'nde',
        'iso-639-2b' => 'nde',
        'iso-639-3' => 'nde',
        'countries' => ['ZW' => 'Zimbabwe'],
        'scripts' => []
    ],
    [
        'name' => 'nepali',
        'native' => 'नेपाली',
        'iso-639-1' => 'ne',
        'iso-639-2t' => 'nep',
        'iso-639-2b' => 'nep',
        'iso-639-3' => 'nep',
        'countries' => ['IN' => 'India', 'NP' => 'Nepal'],
        'scripts' => []
    ],
    [
        'name' => 'ndonga',
        'native' => 'owambo',
        'iso-639-1' => 'ng',
        'iso-639-2t' => 'ndo',
        'iso-639-2b' => 'ndo',
        'iso-639-3' => 'ndo',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'norwegian bokmål',
        'native' => 'norsk bokmål',
        'iso-639-1' => 'nb',
        'iso-639-2t' => 'nob',
        'iso-639-2b' => 'nob',
        'iso-639-3' => 'nob',
        'countries' => ['NO' => 'Norway'],
        'scripts' => []
    ],
    [
        'name' => 'norwegian nynorsk',
        'native' => 'norsk nynorsk',
        'iso-639-1' => 'nn',
        'iso-639-2t' => 'nno',
        'iso-639-2b' => 'nno',
        'iso-639-3' => 'nno',
        'countries' => ['NO' => 'Norway'],
        'scripts' => []
    ],
    [
        'name' => 'norwegian',
        'native' => 'norsk',
        'iso-639-1' => 'no',
        'iso-639-2t' => 'nor',
        'iso-639-2b' => 'nor',
        'iso-639-3' => 'nor + 2',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'nyankole',
        'native' => 'nyankore',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'nyn',
        'countries' => ['UG' => 'Uganda'],
        'scripts' => []
    ],
    [
        'name' => 'sichuan yi',
        'native' => 'ꆈꌠ꒿ nuosuhxop',
        'iso-639-1' => 'ii',
        'iso-639-2t' => 'iii',
        'iso-639-2b' => 'iii',
        'iso-639-3' => 'iii',
        'countries' => ['CN' => 'China'],
        'scripts' => []
    ],
    [
        'name' => 'southern ndebele',
        'native' => 'isindebele',
        'iso-639-1' => 'nr',
        'iso-639-2t' => 'nbl',
        'iso-639-2b' => 'nbl',
        'iso-639-3' => 'nbl',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'occitan',
        'native' => 'occitan, lenga d\'òc',
        'iso-639-1' => 'oc',
        'iso-639-2t' => 'oci',
        'iso-639-2b' => 'oci',
        'iso-639-3' => 'oci',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'ojibwe, ojibwa',
        'native' => 'ᐊᓂᔑᓈᐯᒧᐎᓐ',
        'iso-639-1' => 'oj',
        'iso-639-2t' => 'oji',
        'iso-639-2b' => 'oji',
        'iso-639-3' => 'oji + 7',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'old church slavonic, church slavonic, old bulgarian',
        'native' => 'ѩзыкъ словѣньскъ',
        'iso-639-1' => 'cu',
        'iso-639-2t' => 'chu',
        'iso-639-2b' => 'chu',
        'iso-639-3' => 'chu',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'oromo',
        'native' => 'afaan oromoo',
        'iso-639-1' => 'om',
        'iso-639-2t' => 'orm',
        'iso-639-2b' => 'orm',
        'iso-639-3' => 'orm + 4',
        'countries' => ['ET' => 'Ethiopia', 'KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'oriya',
        'native' => 'ଓଡ଼ିଆ',
        'iso-639-1' => 'or',
        'iso-639-2t' => 'ori',
        'iso-639-2b' => 'ori',
        'iso-639-3' => 'ori',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'ossetian, ossetic',
        'native' => 'ирон æвзаг',
        'iso-639-1' => 'os',
        'iso-639-2t' => 'oss',
        'iso-639-2b' => 'oss',
        'iso-639-3' => 'oss',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'punjabi',
        'native' => 'ਪੰਜਾਬੀ, پنجابی‎',
        'iso-639-1' => 'pa',
        'iso-639-2t' => 'pan',
        'iso-639-2b' => 'pan',
        'iso-639-3' => 'pan',
        'countries' => ['IN' => 'India', 'PK' => 'Pakistan'],
        'scripts' => ['arab' => 'arabic', 'guru' => 'gurmukhi']
    ],
    [
        'name' => 'pāli',
        'native' => 'पाऴि',
        'iso-639-1' => 'pi',
        'iso-639-2t' => 'pli',
        'iso-639-2b' => 'pli',
        'iso-639-3' => 'pli',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'persian',
        'native' => 'فارسی',
        'iso-639-1' => 'fa',
        'iso-639-2t' => 'fas',
        'iso-639-2b' => 'per',
        'iso-639-3' => 'fas + 2',
        'countries' => ['AF' => 'Afghanistan', 'IR' => 'Iran'],
        'scripts' => []
    ],
    [
        'name' => 'polish',
        'native' => 'język polski, polszczyzna',
        'iso-639-1' => 'pl',
        'iso-639-2t' => 'pol',
        'iso-639-2b' => 'pol',
        'iso-639-3' => 'pol',
        'countries' => ['PL' => 'Poland'],
        'scripts' => []
    ],
    [
        'name' => 'pashto',
        'native' => 'پښتو',
        'iso-639-1' => 'ps',
        'iso-639-2t' => 'pus',
        'iso-639-2b' => 'pus',
        'iso-639-3' => 'pus + 3',
        'countries' => ['AF' => 'Afghanistan'],
        'scripts' => []
    ],
    [
        'name' => 'portuguese',
        'native' => 'português',
        'iso-639-1' => 'pt',
        'iso-639-2t' => 'por',
        'iso-639-2b' => 'por',
        'iso-639-3' => 'por',
        'countries' => ['BR' => 'Brazil', 'GW' => 'Guinea-Bissau', 'MZ' => 'Mozambique', 'PT' => 'Portugal'],
        'scripts' => []
    ],
    [
        'name' => 'quechua',
        'native' => 'runa simi, kichwa',
        'iso-639-1' => 'qu',
        'iso-639-2t' => 'que',
        'iso-639-2b' => 'que',
        'iso-639-3' => 'que + 44',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'romansh',
        'native' => 'rumantsch grischun',
        'iso-639-1' => 'rm',
        'iso-639-2t' => 'roh',
        'iso-639-2b' => 'roh',
        'iso-639-3' => 'roh',
        'countries' => ['CH' => 'Switzerland'],
        'scripts' => []
    ],
    [
        'name' => 'kirundi',
        'native' => 'ikirundi',
        'iso-639-1' => 'rn',
        'iso-639-2t' => 'run',
        'iso-639-2b' => 'run',
        'iso-639-3' => 'run',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'romanian',
        'native' => 'limba română',
        'iso-639-1' => 'ro',
        'iso-639-2t' => 'ron',
        'iso-639-2b' => 'rum',
        'iso-639-3' => 'ron',
        'countries' => ['MD' => 'Moldova', 'RO' => 'Romania'],
        'scripts' => []
    ],
    [
        'name' => 'rombo',
        'native' => 'kirombo',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'rof',
        'countries' => ['TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'russian',
        'native' => 'русский язык',
        'iso-639-1' => 'ru',
        'iso-639-2t' => 'rus',
        'iso-639-2b' => 'rus',
        'iso-639-3' => 'rus',
        'countries' => ['MD' => 'Moldova', 'RU' => 'Russia', 'UA' => 'Ukraine'],
        'scripts' => []
    ],
    [
        'name' => 'rwa',
        'native' => 'rwa',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'rwk',
        'countries' => ['TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'sanskrit (saṁskṛta)',
        'native' => 'संस्कृतम्',
        'iso-639-1' => 'sa',
        'iso-639-2t' => 'san',
        'iso-639-2b' => 'san',
        'iso-639-3' => 'san',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'sardinian',
        'native' => 'sardu',
        'iso-639-1' => 'sc',
        'iso-639-2t' => 'srd',
        'iso-639-2b' => 'srd',
        'iso-639-3' => 'srd + 4',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'sindhi',
        'native' => 'सिन्धी, سنڌي، سندھی‎',
        'iso-639-1' => 'sd',
        'iso-639-2t' => 'snd',
        'iso-639-2b' => 'snd',
        'iso-639-3' => 'snd',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'northern sami',
        'native' => 'davvisámegiella',
        'iso-639-1' => 'se',
        'iso-639-2t' => 'sme',
        'iso-639-2b' => 'sme',
        'iso-639-3' => 'sme',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'samburu',
        'native' => 'samburu',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'saq',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'samoan',
        'native' => 'gagana fa\'a samoa',
        'iso-639-1' => 'sm',
        'iso-639-2t' => 'smo',
        'iso-639-2b' => 'smo',
        'iso-639-3' => 'smo',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'sango',
        'native' => 'yângâ tî sängö',
        'iso-639-1' => 'sg',
        'iso-639-2t' => 'sag',
        'iso-639-2b' => 'sag',
        'iso-639-3' => 'sag',
        'countries' => ['CF' => 'Central African Republic'],
        'scripts' => []
    ],
    [
        'name' => 'serbian',
        'native' => 'српски језик',
        'iso-639-1' => 'sr',
        'iso-639-2t' => 'srp',
        'iso-639-2b' => 'srp',
        'iso-639-3' => 'srp',
        'countries' => ['BA' => 'Bosnia and Herzegovina', 'ME' => 'Montenegro', 'RS' => 'Serbia'],
        'scripts' => ['cyrl' => 'cyrillic', 'latn' => 'latin']
    ],
    [
        'name' => 'sena',
        'native' => 'sena',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'seh',
        'countries' => ['MZ' => 'Mozambique'],
        'scripts' => []
    ],
    [
        'name' => 'scottish gaelic, gaelic',
        'native' => 'gàidhlig',
        'iso-639-1' => 'gd',
        'iso-639-2t' => 'gla',
        'iso-639-2b' => 'gla',
        'iso-639-3' => 'gla',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'shona',
        'native' => 'chishona',
        'iso-639-1' => 'sn',
        'iso-639-2t' => 'sna',
        'iso-639-2b' => 'sna',
        'iso-639-3' => 'sna',
        'countries' => ['ZW' => 'Zimbabwe'],
        'scripts' => []
    ],
    [
        'name' => 'sinhala',
        'native' => 'සිංහල',
        'iso-639-1' => 'si',
        'iso-639-2t' => 'sin',
        'iso-639-2b' => 'sin',
        'iso-639-3' => 'sin',
        'countries' => ['LK' => 'Sri Lanka'],
        'scripts' => []
    ],
    [
        'name' => 'slovak',
        'native' => 'slovenčina, slovenský jazyk',
        'iso-639-1' => 'sk',
        'iso-639-2t' => 'slk',
        'iso-639-2b' => 'slo',
        'iso-639-3' => 'slk',
        'countries' => ['SK' => 'Slovakia'],
        'scripts' => []
    ],
    [
        'name' => 'slovenian',
        'native' => 'slovenski jezik, slovenščina',
        'iso-639-1' => 'sl',
        'iso-639-2t' => 'slv',
        'iso-639-2b' => 'slv',
        'iso-639-3' => 'slv',
        'countries' => ['SI' => 'Slovenia'],
        'scripts' => []
    ],
    [
        'name' => 'soga',
        'native' => 'soga',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'xog',
        'countries' => ['UG' => 'Uganda'],
        'scripts' => []
    ],
    [
        'name' => 'somali',
        'native' => 'soomaaliga, af soomaali',
        'iso-639-1' => 'so',
        'iso-639-2t' => 'som',
        'iso-639-2b' => 'som',
        'iso-639-3' => 'som',
        'countries' => ['DJ' => 'Djibouti', 'ET' => 'Ethiopia', 'KE' => 'Kenya', 'SO' => 'Somalia'],
        'scripts' => []
    ],
    [
        'name' => 'southern sotho',
        'native' => 'sesotho',
        'iso-639-1' => 'st',
        'iso-639-2t' => 'sot',
        'iso-639-2b' => 'sot',
        'iso-639-3' => 'sot',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'spanish',
        'native' => 'español, castellano',
        'iso-639-1' => 'es',
        'iso-639-2t' => 'spa',
        'iso-639-2b' => 'spa',
        'iso-639-3' => 'spa',
        'countries' => ['AR' => 'Argentina', 'BO' => 'Bolivia', 'CL' => 'Chile', 'CO' => 'Colombia', 'CR' => 'Costa Rica', 'DO' => 'Dominican Republic', 'EC' => 'Ecuador', 'ES' => 'Spain', 'GQ' => 'Equatorial Guinea', 'GT' => 'Guatemala', 'HN' => 'Honduras', 'MX' => 'Mexico', 'NI' => 'Nicaragua', 'PA' => 'Panama', 'PE' => 'Peru', 'PR' => 'Puerto Rico', 'PY' => 'Paraguay', 'SV' => 'El Salvador', 'US' => 'United States', 'UY' => 'Uruguay', 'VE' => 'Venezuela'],
        'scripts' => []
    ],
    [
        'name' => 'sundanese',
        'native' => 'basa sunda',
        'iso-639-1' => 'su',
        'iso-639-2t' => 'sun',
        'iso-639-2b' => 'sun',
        'iso-639-3' => 'sun',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'swahili',
        'native' => 'kiswahili',
        'iso-639-1' => 'sw',
        'iso-639-2t' => 'swa',
        'iso-639-2b' => 'swa',
        'iso-639-3' => 'swa + 2',
        'countries' => ['KE' => 'Kenya', 'TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'swati',
        'native' => 'siswati',
        'iso-639-1' => 'ss',
        'iso-639-2t' => 'ssw',
        'iso-639-2b' => 'ssw',
        'iso-639-3' => 'ssw',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'swedish',
        'native' => 'svenska',
        'iso-639-1' => 'sv',
        'iso-639-2t' => 'swe',
        'iso-639-2b' => 'swe',
        'iso-639-3' => 'swe',
        'countries' => ['FI' => 'Finland', 'SE' => 'Sweden'],
        'scripts' => []
    ],
    [
        'name' => 'swiss german',
        'native' => 'schwiizerdütsch',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => 'gsw',
        'iso-639-2b' => 'gsw',
        'iso-639-3' => 'gsw',
        'countries' => ['CH' => 'Switzerland'],
        'scripts' => []
    ],
    [
        'name' => 'tamil',
        'native' => 'தமிழ்',
        'iso-639-1' => 'ta',
        'iso-639-2t' => 'tam',
        'iso-639-2b' => 'tam',
        'iso-639-3' => 'tam',
        'countries' => ['IN' => 'India', 'LK' => 'Sri Lanka'],
        'scripts' => []
    ],
    [
        'name' => 'taita',
        'native' => 'kidawida',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'dav',
        'countries' => ['KE' => 'Kenya'],
        'scripts' => []
    ],
    [
        'name' => 'tachelhit',
        'native' => 'tašlḥiyt',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'shi',
        'countries' => ['MA' => 'Morocco'],
        'scripts' => ['latn' => 'latin', 'tfng' => 'tifinagh']
    ],
    [
        'name' => 'telugu',
        'native' => 'తెలుగు',
        'iso-639-1' => 'te',
        'iso-639-2t' => 'tel',
        'iso-639-2b' => 'tel',
        'iso-639-3' => 'tel',
        'countries' => ['IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'teso',
        'native' => 'ateso',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'teo',
        'countries' => ['KE' => 'Kenya', 'UG' => 'Uganda'],
        'scripts' => []
    ],
    [
        'name' => 'tajik',
        'native' => 'тоҷикӣ, toğikī, تاجیکی‎',
        'iso-639-1' => 'tg',
        'iso-639-2t' => 'tgk',
        'iso-639-2b' => 'tgk',
        'iso-639-3' => 'tgk',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'thai',
        'native' => 'ไทย',
        'iso-639-1' => 'th',
        'iso-639-2t' => 'tha',
        'iso-639-2b' => 'tha',
        'iso-639-3' => 'tha',
        'countries' => ['TH' => 'Thailand'],
        'scripts' => []
    ],
    [
        'name' => 'tigrinya',
        'native' => 'ትግርኛ',
        'iso-639-1' => 'ti',
        'iso-639-2t' => 'tir',
        'iso-639-2b' => 'tir',
        'iso-639-3' => 'tir',
        'countries' => ['ER' => 'Eritrea', 'ET' => 'Ethiopia'],
        'scripts' => []
    ],
    [
        'name' => 'tibetan',
        'native' => 'བོད་ཡིག',
        'iso-639-1' => 'bo',
        'iso-639-2t' => 'bod',
        'iso-639-2b' => 'tib',
        'iso-639-3' => 'bod',
        'countries' => ['CN' => 'China', 'IN' => 'India'],
        'scripts' => []
    ],
    [
        'name' => 'turkmen',
        'native' => 'türkmen, түркмен',
        'iso-639-1' => 'tk',
        'iso-639-2t' => 'tuk',
        'iso-639-2b' => 'tuk',
        'iso-639-3' => 'tuk',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'tagalog',
        'native' => 'wikang tagalog, ᜏᜒᜃᜅ᜔ ᜆᜄᜎᜓᜄ᜔',
        'iso-639-1' => 'tl',
        'iso-639-2t' => 'tgl',
        'iso-639-2b' => 'tgl',
        'iso-639-3' => 'tgl',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'tswana',
        'native' => 'setswana',
        'iso-639-1' => 'tn',
        'iso-639-2t' => 'tsn',
        'iso-639-2b' => 'tsn',
        'iso-639-3' => 'tsn',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'tonga',
        'native' => 'faka tonga',
        'iso-639-1' => 'to',
        'iso-639-2t' => 'ton',
        'iso-639-2b' => 'ton',
        'iso-639-3' => 'ton',
        'countries' => ['TO' => 'Tonga'],
        'scripts' => []
    ],
    [
        'name' => 'turkish',
        'native' => 'türkçe',
        'iso-639-1' => 'tr',
        'iso-639-2t' => 'tur',
        'iso-639-2b' => 'tur',
        'iso-639-3' => 'tur',
        'countries' => ['TR' => 'Turkey'],
        'scripts' => []
    ],
    [
        'name' => 'tsonga',
        'native' => 'xitsonga',
        'iso-639-1' => 'ts',
        'iso-639-2t' => 'tso',
        'iso-639-2b' => 'tso',
        'iso-639-3' => 'tso',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'tatar',
        'native' => 'татар теле, tatar tele',
        'iso-639-1' => 'tt',
        'iso-639-2t' => 'tat',
        'iso-639-2b' => 'tat',
        'iso-639-3' => 'tat',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'twi',
        'native' => 'twi',
        'iso-639-1' => 'tw',
        'iso-639-2t' => 'twi',
        'iso-639-2b' => 'twi',
        'iso-639-3' => 'twi',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'tahitian',
        'native' => 'reo tahiti',
        'iso-639-1' => 'ty',
        'iso-639-2t' => 'tah',
        'iso-639-2b' => 'tah',
        'iso-639-3' => 'tah',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'uyghur, uighur',
        'native' => 'uyƣurqə, ئۇيغۇرچە‎',
        'iso-639-1' => 'ug',
        'iso-639-2t' => 'uig',
        'iso-639-2b' => 'uig',
        'iso-639-3' => 'uig',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'ukrainian',
        'native' => 'українська мова',
        'iso-639-1' => 'uk',
        'iso-639-2t' => 'ukr',
        'iso-639-2b' => 'ukr',
        'iso-639-3' => 'ukr',
        'countries' => ['UA' => 'Ukraine'],
        'scripts' => []
    ],
    [
        'name' => 'urdu',
        'native' => 'اردو',
        'iso-639-1' => 'ur',
        'iso-639-2t' => 'urd',
        'iso-639-2b' => 'urd',
        'iso-639-3' => 'urd',
        'countries' => ['IN' => 'India', 'PK' => 'Pakistan'],
        'scripts' => []
    ],
    [
        'name' => 'uzbek',
        'native' => 'o‘zbek, ўзбек, أۇزبېك‎',
        'iso-639-1' => 'uz',
        'iso-639-2t' => 'uzb',
        'iso-639-2b' => 'uzb',
        'iso-639-3' => 'uzb + 2',
        'countries' => ['AF' => 'Afghanistan', 'UZ' => 'Uzbekistan'],
        'scripts' => ['arab' => 'arabic', 'cyrl' => 'cyrillic', 'latn' => 'latin']
    ],
    [
        'name' => 'venda',
        'native' => 'tshivenḓa',
        'iso-639-1' => 've',
        'iso-639-2t' => 'ven',
        'iso-639-2b' => 'ven',
        'iso-639-3' => 'ven',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'vietnamese',
        'native' => 'tiếng việt',
        'iso-639-1' => 'vi',
        'iso-639-2t' => 'vie',
        'iso-639-2b' => 'vie',
        'iso-639-3' => 'vie',
        'countries' => ['VN' => 'Vietnam'],
        'scripts' => []
    ],
    [
        'name' => 'volapük',
        'native' => 'volapük',
        'iso-639-1' => 'vo',
        'iso-639-2t' => 'vol',
        'iso-639-2b' => 'vol',
        'iso-639-3' => 'vol',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'vunjo',
        'native' => 'wunjo',
        'iso-639-1' => '',              // TODO
        'iso-639-2t' => '',             // TODO
        'iso-639-2b' => '',             // TODO
        'iso-639-3' => 'vun',
        'countries' => ['TZ' => 'Tanzania'],
        'scripts' => []
    ],
    [
        'name' => 'walloon',
        'native' => 'walon',
        'iso-639-1' => 'wa',
        'iso-639-2t' => 'wln',
        'iso-639-2b' => 'wln',
        'iso-639-3' => 'wln',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'welsh',
        'native' => 'cymraeg',
        'iso-639-1' => 'cy',
        'iso-639-2t' => 'cym',
        'iso-639-2b' => 'wel',
        'iso-639-3' => 'cym',
        'countries' => ['GB' => 'United Kingdom'],
        'scripts' => []
    ],
    [
        'name' => 'wolof',
        'native' => 'wollof',
        'iso-639-1' => 'wo',
        'iso-639-2t' => 'wol',
        'iso-639-2b' => 'wol',
        'iso-639-3' => 'wol',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'western frisian',
        'native' => 'frysk',
        'iso-639-1' => 'fy',
        'iso-639-2t' => 'fry',
        'iso-639-2b' => 'fry',
        'iso-639-3' => 'fry',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'xhosa',
        'native' => 'isixhosa',
        'iso-639-1' => 'xh',
        'iso-639-2t' => 'xho',
        'iso-639-2b' => 'xho',
        'iso-639-3' => 'xho',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'yiddish',
        'native' => 'ייִדיש',
        'iso-639-1' => 'yi',
        'iso-639-2t' => 'yid',
        'iso-639-2b' => 'yid',
        'iso-639-3' => 'yid + 2',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'yoruba',
        'native' => 'yorùbá',
        'iso-639-1' => 'yo',
        'iso-639-2t' => 'yor',
        'iso-639-2b' => 'yor',
        'iso-639-3' => 'yor',
        'countries' => ['NG' => 'Nigeria'],
        'scripts' => []
    ],
    [
        'name' => 'zhuang, chuang',
        'native' => 'saɯ cueŋƅ, saw cuengh',
        'iso-639-1' => 'za',
        'iso-639-2t' => 'zha',
        'iso-639-2b' => 'zha',
        'iso-639-3' => 'zha + 16',
        'countries' => [],
        'scripts' => []
    ],
    [
        'name' => 'zulu',
        'native' => 'isizulu',
        'iso-639-1' => 'zu',
        'iso-639-2t' => 'zul',
        'iso-639-2b' => 'zul',
        'iso-639-3' => 'zul',
        'countries' => ['ZA' => 'South Africa'],
        'scripts' => []
    ],

];