<?php
/*
 * This file is part of the Microweber framework.
 *
 * (c) Microweber CMS LTD
 *
 * For full license information see
 * https://github.com/microweber/microweber/blob/master/LICENSE
 *
 */

namespace Modules\Customer\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider;
use Modules\Customer\Listeners\CreateCustomerFromOrderListener;
use Modules\Order\Events\OrderWasCreated;

class CustomerEventServiceProvider extends EventServiceProvider
{
    protected $listen = [
        OrderWasCreated::class => [
            CreateCustomerFromOrderListener::class
        ]
    ];
}

