{{--
type: layout
name: Button dialog
description: Opens video in a popup
--}}

@php
    if(!isset($params['width'])) {
        $params['width'] = 1200;
    }
@endphp

<script>
    $(document).ready(function () {
        $('#video-dialog-button-{{ $params['id'] ?? '' }}').on('click', function (){
            $('#video-dialog-template-{{ $params['id'] ?? '' }}').mwDialog({
                header: false,
                skin: 'video',
                closeButtonAppendTo: '.mw-dialog-holder',
                width: {{ $params['width'] ?? 1200 }},
                height: '100%',
                top: '50%'
            });
            var dialog = mw.dialog.get()

            mw.spinner(({element: dialog.dialogContainer, size: 30})).show();
            $('iframe,img', dialog.dialogContainer).on('load', function (){
                mw.spinner(({element: dialog.dialogContainer, size: 30})).remove();
            })
        })
    });
</script>

<style>
    #video-dialog-button-{{ $params['id'] ?? '' }}{
        font-size: 0;
    }
    #video-dialog-button-{{ $params['id'] ?? '' }}:after{
        content: "\eb86";
        font-family: 'icomoon-solid';
        speak: none;
        font-style: normal;
        font-weight: normal;
        font-variant: normal;
        text-transform: none;
        line-height: 1;
        -webkit-font-smoothing: antialiased;
        font-size: 100px;
        color: var(--mw-primary-color);
    }
</style>
<div class="video-dialog-container">
<template id="video-dialog-template-{{ $params['id'] ?? '' }}" style="display: none">{!! $code ?? '' !!}</template>
<span id="video-dialog-button-{{ $params['id'] ?? '' }}"></span>
</div>
