<?php

namespace Modules\Country\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use MicroweberPackages\LaravelModules\Providers\BaseModuleServiceProvider;
use Modules\Country\Repositories\CountryManager;

class CountryServiceProvider extends BaseModuleServiceProvider
{
    protected string $moduleName = 'Country';

    protected string $moduleNameLower = 'country';

    /**
     * Boot the application events.
     */
    public function boot(): void
    {


    }

    /**
     * Register the service provider.
     */
    public function register(): void
    {
        $this->registerConfig();
        $this->loadMigrationsFrom(module_path($this->moduleName, 'database/migrations'));

        /**
         * @property CountryManager    $country_manager
         */
        $this->app->singleton('country_manager', function ($app) {
            return new CountryManager();
        });

    }

}
