<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    /**
     * Run the migrations.
     */
    public function up(): void
    {


        if (Schema::hasTable('subscriptions')) {
            return;
        }
        Schema::create('subscriptions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('customer_id');
            $table->integer('user_id')->nullable();
            $table->integer('subscription_plan_id')->nullable();;
            $table->string('subscription_customer_id')->nullable();
            $table->string('type')->nullable();
            $table->string('name')->nullable();
            $table->string('stripe_id')->nullable();;
            $table->string('stripe_status')->nullable();;
            $table->string('stripe_price')->nullable();
            $table->integer('quantity')->nullable();
            $table->timestamp('trial_ends_at')->nullable();
            $table->timestamp('starts_at')->nullable();
            $table->timestamp('ends_at')->nullable();
            $table->timestamps();
        });

        try {
            Schema::create('subscriptions', function (Blueprint $table) {
                $table->unique('stripe_id');
            });
        } catch (\Exception $e) {
            // Handle the exception if needed
        }

    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions');
    }
};
