<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if(Schema::hasTable('subscriptions_manual')) {
            return;
        }
        Schema::create('subscriptions_manual', function (Blueprint $table) {
            $table->id();
            $table->integer('subscription_plan_id')->nullable();
            $table->integer('user_id')->nullable();
            $table->tinyInteger('auto_activate_free_trial_after_date')->nullable();
            $table->dateTime('activate_free_trial_after_date')->nullable();
            $table->timestamps();

        });

        try {
            Schema::create('subscriptions_manual', function (Blueprint $table) {
                $table->index(['user_id']);
            });
        } catch (\Exception $e) {
            // Handle the exception if needed
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('subscriptions_manual');
    }
};
