const colors = require('tailwindcss/colors')
const defaultTheme = require("tailwindcss/defaultTheme.js");

module.exports = {
    darkMode: 'class',
    future: {
        relativeContentPathsByDefault: true,
    },
    // mode: 'jit',
    //  purge: [
    //      // Your CSS will rebuild any time *any* file in `src` changes
    //      './resources/assets/**/*.*',
    //  ],
    theme: {
        extend: {
            fontFamily: {
                sans: ['var(--font-family)', ...defaultTheme.fontFamily.sans],
            },

            colors: {
                blue: {
                    50: '#edf5ff',
                    100: '#d0e2ff',
                    200: '#a6c8ff',
                    300: '#78a9ff',
                    400: '#4589ff',
                    500: '#4991fc',
                    600: '#4592ff',
                    700: '#0f62fe',
                    800: '#001d6f',
                    900: '#001141',
                },
                gray: {
                    '50': '#f9fafb',
                    '100': '#f3f4f6',
                    '200': '#e5e7eb',
                    '300': '#d1d5db',
                    '400': '#9ca3af',
                    '500': '#6b7280',
                    '600': '#182433',
                    '700': '#182433',
                    '800': '#182433',
                    '900': '#182433',
                    '950': '#030712'
                },
                custom: {
                    50: '#edf5ff',
                    100: '#d0e2ff',
                    200: '#a6c8ff',
                    300: '#78a9ff',
                    400: '#4589ff',
                    500: '#4991fc',
                    600: '#4592ff',
                    700: '#0f62fe',
                    800: '#001d6f',
                    900: '#001141',
                },
                danger: {
                    50: 'rgba(var(--danger-50), <alpha-value>)',
                    100: 'rgba(var(--danger-100), <alpha-value>)',
                    200: 'rgba(var(--danger-200), <alpha-value>)',
                    300: 'rgba(var(--danger-300), <alpha-value>)',
                    400: 'rgba(var(--danger-400), <alpha-value>)',
                    500: 'rgba(var(--danger-500), <alpha-value>)',
                    600: 'rgba(var(--danger-600), <alpha-value>)',
                    700: 'rgba(var(--danger-700), <alpha-value>)',
                    800: 'rgba(var(--danger-800), <alpha-value>)',
                    900: 'rgba(var(--danger-900), <alpha-value>)',
                    950: 'rgba(var(--danger-950), <alpha-value>)',
                },
                gray: {
                    50: 'rgba(var(--gray-50), <alpha-value>)',
                    100: 'rgba(var(--gray-100), <alpha-value>)',
                    200: 'rgba(var(--gray-200), <alpha-value>)',
                    300: 'rgba(var(--gray-300), <alpha-value>)',
                    400: 'rgba(var(--gray-400), <alpha-value>)',
                    500: 'rgba(var(--gray-500), <alpha-value>)',
                    600: 'rgba(var(--gray-600), <alpha-value>)',
                    700: 'rgba(var(--gray-700), <alpha-value>)',
                    800: 'rgba(var(--gray-800), <alpha-value>)',
                    900: 'rgba(var(--gray-900), <alpha-value>)',
                    950: 'rgba(var(--gray-950), <alpha-value>)',
                },
                info: {
                    50: 'rgba(var(--info-50), <alpha-value>)',
                    100: 'rgba(var(--info-100), <alpha-value>)',
                    200: 'rgba(var(--info-200), <alpha-value>)',
                    300: 'rgba(var(--info-300), <alpha-value>)',
                    400: 'rgba(var(--info-400), <alpha-value>)',
                    500: 'rgba(var(--info-500), <alpha-value>)',
                    600: 'rgba(var(--info-600), <alpha-value>)',
                    700: 'rgba(var(--info-700), <alpha-value>)',
                    800: 'rgba(var(--info-800), <alpha-value>)',
                    900: 'rgba(var(--info-900), <alpha-value>)',
                    950: 'rgba(var(--info-950), <alpha-value>)',
                },
                primary: {
                    50: 'rgba(var(--primary-50), <alpha-value>)',
                    100: 'rgba(var(--primary-100), <alpha-value>)',
                    200: 'rgba(var(--primary-200), <alpha-value>)',
                    300: 'rgba(var(--primary-300), <alpha-value>)',
                    400: 'rgba(var(--primary-400), <alpha-value>)',
                    500: 'rgba(var(--primary-500), <alpha-value>)',
                    600: 'rgba(var(--primary-600), <alpha-value>)',
                    700: 'rgba(var(--primary-700), <alpha-value>)',
                    800: 'rgba(var(--primary-800), <alpha-value>)',
                    900: 'rgba(var(--primary-900), <alpha-value>)',
                    950: 'rgba(var(--primary-950), <alpha-value>)',
                },
                success: {
                    50: 'rgba(var(--success-50), <alpha-value>)',
                    100: 'rgba(var(--success-100), <alpha-value>)',
                    200: 'rgba(var(--success-200), <alpha-value>)',
                    300: 'rgba(var(--success-300), <alpha-value>)',
                    400: 'rgba(var(--success-400), <alpha-value>)',
                    500: 'rgba(var(--success-500), <alpha-value>)',
                    600: 'rgba(var(--success-600), <alpha-value>)',
                    700: 'rgba(var(--success-700), <alpha-value>)',
                    800: 'rgba(var(--success-800), <alpha-value>)',
                    900: 'rgba(var(--success-900), <alpha-value>)',
                    950: 'rgba(var(--success-950), <alpha-value>)',
                },
                warning: {
                    50: 'rgba(var(--warning-50), <alpha-value>)',
                    100: 'rgba(var(--warning-100), <alpha-value>)',
                    200: 'rgba(var(--warning-200), <alpha-value>)',
                    300: 'rgba(var(--warning-300), <alpha-value>)',
                    400: 'rgba(var(--warning-400), <alpha-value>)',
                    500: 'rgba(var(--warning-500), <alpha-value>)',
                    600: 'rgba(var(--warning-600), <alpha-value>)',
                    700: 'rgba(var(--warning-700), <alpha-value>)',
                    800: 'rgba(var(--warning-800), <alpha-value>)',
                    900: 'rgba(var(--warning-900), <alpha-value>)',
                    950: 'rgba(var(--warning-950), <alpha-value>)',
                },
            },
        },
    },

    plugins: [

        require('@tailwindcss/typography'),
        require('@tailwindcss/forms'),
        require('@tailwindcss/aspect-ratio'),
        require('@tailwindcss/container-queries'),

    ],
    //  safelist: [{ pattern: /./ }],


    content: {
        relative: true,
        files: [
            './../../app/Filament/Admin/**/*.php',
            './../../resources/**/*.blade.php',
            './resources/assets/css/*.css',
            './resources/assets/css/**/*.scss',
            './../../Modules/**/*.blade.php',
            './../../Modules/**/resources/views/**/*.blade.php',
            './../../src/MicroweberPackages/**/*.blade.php',
            './../../src/MicroweberPackages/**/resources/views/**/*.blade.php',
            './../../vendor/jaocero/radio-deck/resources/views/**/*.blade.php',
            './../../vendor/filament/**/*.blade.php',
            './../../userfiles/modules/**/*.blade.php',
            './../../userfiles/modules/**/src/resources/views/**/*.blade.php',
            './../../userfiles/modules/*/src/resources/views/**/*.blade.php',
            './../../public/userfiles/modules/**/*.blade.php',
            './../../public/userfiles/modules/**/src/resources/views/**/*.blade.php',
            './../../public/userfiles/modules/*/src/resources/views/**/*.blade.php',
        ],
    },

}
