<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        try {
            $tableNames = config('permission.table_names');

            if (!Schema::hasTable($tableNames['model_has_roles'])) {
                Schema::create($tableNames['model_has_roles'], function (Blueprint $table) use ($tableNames) {
                    $table->unsignedInteger('role_id');
                    $table->morphs('model');
                    $table->primary(['role_id', 'model_id', 'model_type']);
                });
            }

            if (!Schema::hasTable($tableNames['role_has_permissions'])) {
                Schema::create($tableNames['role_has_permissions'], function (Blueprint $table) use ($tableNames) {
                    $table->unsignedInteger('permission_id');
                    $table->unsignedInteger('role_id');

                    $table->primary(['permission_id', 'role_id']);

                    app('cache')->forget('spatie.permission.cache');
                });
            }

        } catch (\Exception $e) {
            // do nothing
        }
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        $tableNames = config('permission.table_names');

        Schema::dropIfExists($tableNames['role_has_permissions']);
        Schema::dropIfExists($tableNames['model_has_roles']);
        Schema::dropIfExists($tableNames['model_has_permissions']);
        Schema::dropIfExists($tableNames['roles']);
        Schema::dropIfExists($tableNames['permissions']);
    }
};
