<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if(Schema::hasTable('teamcards')) {
            return;
        }

        Schema::create('teamcards', function (Blueprint $table) {
            $table->id();
            $table->string('name')->nullable();
            $table->string('file')->nullable();
            $table->longText('bio')->nullable();
            $table->string('role')->nullable();
            $table->string('website')->nullable();
            $table->integer('position')->nullable();
            $table->string('rel_type')->nullable();
            $table->string('rel_id')->nullable();
            $table->longText('settings')->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('teamcards');
    }
};
