<?php
namespace Modules\Export\Tests\Unit;

use Modules\Post\Models\Post;
use Modules\Export\Models\Import;

use Faker\Factory;
use MicroweberPackages\Core\tests\TestCase;
use Modules\Backup\SessionStepper;
use Modules\Export\Services\Export;


/**
 * Run test
 * @author Bobi Microweber
 * @command php phpunit.phar --filter ExportTest
 */

class ExportTest extends TestCase
{
        private static $_titles = array();
        private static $_exportedFile = '';

        public function testEncoding() {

                $locales = array('el_GR', 'bg_BG', 'en_EN','at_AT','ko_KR','kk_KZ','ja_JP','fi_FI','es_ES');

                foreach($locales as $locale) {

                        $faker = Factory::create($locale);

                        $inputTitle = $faker->name;

                        if (empty($inputTitle)) {
                                $this->assertTrue(false);
                        } else {
                                $this->assertTrue(true);

                                $contentId=  save_content(array("title"=>$inputTitle));
                                $outputContent = get_content("single=true&id=" . $contentId);

                                $this->assertSame($outputContent['title'], $inputTitle);

                                self::$_titles[] = array("id"=>$contentId, "title"=>$inputTitle, "url"=>$outputContent['full_url']);
                        }
                }


        }

        public function testFullExport() {

           //     clearcache();
        $sessionId = SessionStepper::generateSessionId(20);

        $manager = new  Export();
        $manager->setSessionId($sessionId);
                $manager->setExportAllData(true);

                $i = 0;
                while (true) {

                        $export = $manager->start();

                        $exportBool = false;
                        if (!empty($export)) {
                                $exportBool = true;
                        }

                        $this->assertTrue($exportBool);

                        if (isset($export['current_step'])) {
                                $this->assertArrayHasKey('current_step', $export);
                                $this->assertArrayHasKey('total_steps', $export);
                                $this->assertArrayHasKey('percentage', $export);
                                $this->assertArrayHasKey('data', $export);
                        }

                        // The last exort step
                        if (isset($export['success'])) {
                                $this->assertArrayHasKey('data', $export);
                                $this->assertArrayHasKey('download', $export['data']);
                                $this->assertArrayHasKey('filepath', $export['data']);
                                $this->assertArrayHasKey('filename', $export['data']);

                                self::$_exportedFile = $export['data']['filepath'];

                                break;
                        }

                        if ($i > 100) {
                                break;
                        }

                        $i++;
                }

        $contentCount = (int) get_content('count=1');

        $zip = new \ZipArchive;
        $res = $zip->open(self::$_exportedFile);
        $this->assertTrue($res === TRUE);

        $jsonFileInsideZip = str_replace('.zip', '.json', self::$_exportedFile);
        $jsonFileInsideZip = basename($jsonFileInsideZip);
        $jsonFileContent = $zip->getFromName($jsonFileInsideZip);

        $jsonExportTest = json_decode($jsonFileContent,true);

        $this->assertTrue(!empty($jsonExportTest['content']));
        $this->assertEquals(count($jsonExportTest['content']), $contentCount);

        }

        public function testImportedEncoding() {

                $urls = array();
                foreach (self::$_titles as $title) {
                        $urls[$title['url']] = $title;
                }

                $posts = Post::all();

                if (empty($posts)) {
                        $this->assertTrue(false);
                        return;
                }

        $this->assertFalse(empty($posts));

                foreach($posts->toArray() as $post) {
                        if (array_key_exists($post['url'], $urls)) {
                                $this->assertSame($urls[$post['url']]['title'], $post['title']);
                        }
                }
        }


}
