<?php

namespace Modules\Btn\Providers;

use Illuminate\Support\Facades\Blade;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Route;
use MicroweberPackages\Filament\Facades\FilamentRegistry;
use MicroweberPackages\LaravelModules\Providers\BaseModuleServiceProvider;
use MicroweberPackages\LiveEdit\Facades\LiveEditManager;
use MicroweberPackages\Microweber\Facades\Microweber;
use Modules\Audio\Filament\AudioModuleSettings;
use Modules\Btn\Filament\BtnModuleSettings;

class BtnServiceProvider extends BaseModuleServiceProvider
{
    protected string $moduleName = 'Btn';

    protected string $moduleNameLower = 'btn';

    /**
     * Boot the application events.
     */
    public function boot(): void
    {


    }

    /**
     * Register the service provider.
     */
    public function register(): void
    {
        $this->registerTranslations();
        $this->registerConfig();
        $this->registerViews();
        $this->loadMigrationsFrom(module_path($this->moduleName, 'database/migrations'));

        FilamentRegistry::registerPage(BtnModuleSettings::class);
        Microweber::module( \Modules\Btn\Microweber\BtnModule::class);

        LiveEditManager::addScript('btn-module-quick-settings', asset('modules/btn/js/quick-settings.js'));

    }

}
