<?php
/*
 * This file is part of the Microweber framework.
 *
 * (c) Microweber CMS LTD
 *
 * For full license information see
 * https://github.com/microweber/microweber/blob/master/LICENSE
 *
 */

namespace MicroweberPackages\Option\Providers;

use Illuminate\Foundation\AliasLoader;
use Illuminate\Support\ServiceProvider;
use MicroweberPackages\Multilanguage\TranslateManager;
use MicroweberPackages\Option\Facades\Option as OptionFacade;
use MicroweberPackages\Option\GlobalOptions;
use MicroweberPackages\Option\Models\Option;
use MicroweberPackages\Option\Models\Option as OptionModel;
use MicroweberPackages\Option\OptionManager;
use MicroweberPackages\Option\Repositories\OptionRepository;
use MicroweberPackages\Option\TranslateTables\TranslateOption;
use Modules\ContentField\TranslateTables\TranslateContentField;


class OptionServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
        $this->loadMigrationsFrom(dirname(__DIR__) . '/migrations/');

        $this->app->singleton('option_manager', function ($app) {
            return new OptionManager();
        });

        $this->app->bind('option',function(){
            return new OptionModel();
        });

        $this->app->singleton('global_options', function ($app) {
            return new GlobalOptions(OptionModel::all());
        });



        /**
         * @property OptionRepository   $option_repository
         */
        $this->app->bind('option_repository', function () {
            return app()->make(OptionRepository::class);
        });

    }

    /**
     * Bootstrap the application services.
     *
     * @return void
     */
    public function boot()
    {

        if(app()->bound('translate_manager')) {
             app()->translate_manager->addTranslateProvider(TranslateOption::class);
        }

        $aliasLoader = AliasLoader::getInstance();
        $aliasLoader->alias('Option', OptionFacade::class);

        $this->loadRoutesFrom(dirname(__DIR__) . '/routes/api.php');

    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['option_manager', 'option'];
    }
}
