<div class="shop-products">

    <div class="product position-relative">
        <a class="text-decoration-none" href="{{content_link($product->id)}}">
            <div class="background-image-holder" style="background-image: url('{{$product->thumbnail(1000,1000)}}'); height: 450px; background-size: cover;">

                <div @if($product->getContentDataByFieldName('label-color'))
                         style="background-color: {{$product->getContentDataByFieldName('label-color')}} "
                    @endif >
                    @if($product->getContentDataByFieldName('label-type') == 'percent')
                        <div class="discount-label">
                                                    <span class="discount-percentage">
                                                          {{$product->getDiscountPercentage()}} %
                                                    </span>
                            <span class="discount-label-text"><?php _lang("Discount"); ?></span>
                        </div>

                    @endif
                    @if($product->getContentDataByFieldName('label-type') == 'text' and $product->getContentDataByFieldName('label'))

                        <div class="position-absolute  top-0 left-0 m-2" style="z-index: 3;">
                            <div class="badge text-white px-3 pb-1 pt-2 rounded-0" style="background-color: {{$product->getContentDataByFieldName('label-color')}};">{{$product->getContentDataByFieldName('label')}}</div>
                        </div>
                    @endif
                </div>

            </div>
            <h4 class="mt-3">{{$product->title}}</h4>
        </a>

        <p>{{ Str::limit($product->description, 150) }}</p>

        <div class="d-flex items-center text-center align-items-center price-holder">

            @if($product->hasSpecialPrice())
                <p class="price-old mb-0 fs-3"><?php print currency_format($product->price); ?></p>
                <p class="price mb-0 fs-3"><?php print currency_format($product->specialPrice); ?></p>
            @else
                <p class="price mb-0 fs-3"><?php print currency_format($product->price); ?></p>
            @endif

        </div>

        @foreach($product->tags as $tag)
            <span class="badge badge-lg"><a href="?tags[]={{$tag->slug}}">{{$tag->name}}</a></span>
        @endforeach
    </div>
</div>
